# alle Objekte lschen:
rm(list=ls())
# libaries MASS und DAAG laden
library(MASS)
library(DAAG)
#Graphikausgabe unterteilen (hier nur eine Gaphik
par(mfrow=c(1,1))
# Erzeugen normalverteilter Zufallszahlen
x <- rnorm(10000)
y <- rnorm(10000)
# Datstellung als Histogramm
truehist(c(x,y+3),nbins=50)
pause() # mit return geht's weiter 
# Erzeugen einer gegltteten zweidimensionalen Dichtefunktion der Daten
dd <- kde2d(x,y,n=40)
# Darstellung als Contourplot mit verschiedenen Farbschemata
filled.contour(dd,color = terrain.colors,nlevels=50)
pause()
filled.contour(dd,color = rainbow,nlevels=50)
#pause()
filled.contour(dd,color = heat.colors,nlevels=50)
#pause()
filled.contour(dd,color = cm.colors,nlevels=50)
#pause()
filled.contour(dd,color = topo.colors,nlevels=50, plot.axes={ axis(1); axis(2); points(dd) })
filled.contour(dd,color = topo.colors,nlevels=50,plot.axes={axis(1,at=seq(-3.5,3.5,by=1));axis(2,at=seq(-3.5,3.5,by=1))})
title(main = "2D density plot", font.main = 4)
pause()
# Andere Art der Datstellung
image(dd,col=topo.colors(100), axes=FALSE) # Graphik ohne Achsen
contour(dd,nlevels=10,add=T) # Hinzufgen von Conourlinien
# Achsenbeschriftungen
axis(1, at = seq(-3.5, 3.5, by = 1),add=T)
axis(2, at = seq(-3.5, 3.5, by = 1),add=T)
title(main = "2D density plot", font.main = 4)
# Box um Grphik zeichnen:
box()
