
# alle Objekte lschen:
rm(list=ls())
# libaries MASS und DAAG laden
library(MASS)
library(DAAG)
# Graphikausgabe unterteilen (hier nur eine Gaphik)
par(mfrow=c(1,1))
# Stufenweise einen data-frame erzeugen
x <- seq(1,20,0.5) # x enthlt Zahlensequenz
w <- 1+x/2 # (x,w) ist eine Gerade
y <- x+w*rnorm(x) # y ist eine verrauschte Gerade
dum <- data.frame(x,y,w) # Anschauen mit "dum ?"
rm(x,y,w)
attach(dum) # Variable in dum knnen direkt angesprochen werden
# Lineare Regression
fm <- lm(y~x, data=dum)
print(summary(fm))
pause()
# Gewichtete Regression by w
fm1 <- lm(y~x, data=dum,weight=1/w^2)
print(summary(fm1))
pause()
# Glatte Regression
lrf <- loess(y~x, dum)
print(summary(lrf))
pause()
# Plot der Regressionsgeraden bzw. -kurven
print("******** Plot der Regressionsgeraden bzw. -kurven ***********")
plot(x,y,asp=1)
lines(spline(x,fitted(lrf)),col=2,lwd=2)
points(x,fitted(lrf),pch=15)
abline(0,1,lty=3,col=3,lwd=2)
abline(fm,col=4,lwd=3)
abline(fm1,col=5,lty=4,lwd=3)
pause()
# Graphikausgabe unterteilen (hier neun Gaphiken)
par(mfrow=c(3,3))
# Residuen der drei Methoden
plot(fitted(fm),resid(fm),xlab="Fitted Values",
ylab="Residuals",main="Standard")
plot(fitted(fm1),resid(fm1),xlab="Fitted Values",
ylab="Residuals",main="Weighted")
plot(fitted(lrf),resid(lrf),xlab="Fitted Values",
ylab="Residuals",main="Smooth")
# Gefitted gegen gemessen
plot(y,fitted(fm),xlab="y",
ylab="fitted",main="measured vs. fitted, standard",asp=1)
plot(y,fitted(fm1),xlab="y",
ylab="fitted",main="measured vs. fitted, weighted",asp=1)
plot(y,fitted(lrf),xlab="y",
ylab="fitted",main="measured vs. fitted, smooth",asp=1)
# Quantilplots: emp. Quantile gegen theoretische Quantile
qqnorm(resid(fm),main="Q-Q standard"); qqline(resid(fm))
qqnorm(resid(fm1),main="Q-Q weighted"); qqline(resid(fm1))
qqnorm(resid(lrf),main="Q-Q smooth"); qqline(resid(lrf))
# Korrelation gemessen-gefitted
print("normal R:"); print(cor(y,fitted(fm)))
print("weighted R:"); print(cor(y,fitted(fm1)))
print("smoothed R:"); print(cor(y,fitted(lrf)))
detach(dum) # hebt attach(dum) wieder auf


