library(DAAG)
library(gstat)
library(sp)
# --- Daten einlesen ---
#
#setwd("C:/Dokumente und Einstellungen/Bernd Huwe/Eigene Dateien/Projekte/Laufend/FG_Ecuador/daten/Statistik/Geostatistik/Q2")
d <- read.table("Q2_A_all_mod.dat",header=TRUE)
dat <- d[,c(1,2,3,18)]
cc <- complete.cases(dat)
dat <- dat[cc,]
#dat[,4] <- log10(dat[,4])
print("  ")
#
# --- Variogrammanalyse ---
#
smry <- summary(dat)
print(smry)
#
# --- variogram cloud ---
#
print("--- Variogram cloud ---")
g <- variogram(KsRos~1, loc=~X+Y, dat, cloud=T)
par(mfrow=c(2,1))
plot(g$dist,g$gamma,ylim=range(0,max(g$gamma)),xlim=range(0,max(g$dist)),main="Variogram Cloud ohne Trend")
g <- variogram(KsRos~X+Y, loc=~X+Y, dat, cloud=T)
plot(g$dist,g$gamma,ylim=range(0,max(g$gamma)),xlim=range(0,max(g$dist)),main="Variogram Cloud linearer Trend")
pause()
#
# --- ohne Trend ---
#
cut.val = 200
wdth.val = cut.val/10
#
print("--- ohne Trend ---")
g <- variogram(KsRos~1, loc=~X+Y, dat, cutoff=cut.val,width=wdth.val)
par(mfrow=c(2,2))
plot(g$dist,g$gamma,ylim=range(0,max(g$gamma)),xlim=range(0,max(g$dist)),main="ohne Trend")
plot(g$dist,g$np,ylim=range(0,max(g$np)),xlim=range(0,max(g$dist)),main="Anzahl Wertepaare")
pause()
#
# --- mit Trend ---
#
print("--- mit Trend ---")
g <- variogram(KsRos~X+Y, loc=~X+Y, dat, cutoff=cut.val,width=wdth.val)
plot(g$dist,g$gamma,ylim=range(0,max(g$gamma)),xlim=range(0,max(g$dist)),main="linearer Trend")
#g <- variogram(KsRos~X+Y+I(X^2)+I(Y^2)+I(X*Y), loc=~X+Y, dat, cutoff=cut.val,width=wdth.val)
g <- variogram(KsRos~X+Y+X^2+Y^2+X*Y, loc=~X+Y, dat, cutoff=cut.val,width=wdth.val)
plot(g$dist,g$gamma,ylim=range(0,max(g$gamma)),xlim=range(0,max(g$dist)),main="quadratischer Trend")
pause()

print("--- directional ---")
g <- variogram(KsRos~1, loc=~X+Y, dat, alpha=c(0,45,90,135), cutoff=cut.val,width=wdth.val)
par(mfrow=c(2,2))
g[,4] <- factor(g$dir.hor)
plot(g$dist[g$dir.hor=="0"],g$gamma[g$dir.hor=="0"],ylim=range(0,max(g$gamma)),xlim=range(0,max(g$dist)),main="directional, ohne Trend , 0")
plot(g$dist[g$dir.hor=="45"],g$gamma[g$dir.hor=="45"],ylim=range(0,max(g$gamma)),xlim=range(0,max(g$dist)),main="directional, ohne Trend , 45")
plot(g$dist[g$dir.hor=="90"],g$gamma[g$dir.hor=="90"],ylim=range(0,max(g$gamma)),xlim=range(0,max(g$dist)),main="directional, ohne Trend , 90")
plot(g$dist[g$dir.hor=="135"],g$gamma[g$dir.hor=="135"],ylim=range(0,max(g$gamma)),xlim=range(0,max(g$dist)),main="directional, ohne Trend , 135")
pause()
#
# --- Ende ---