rm(list=ls())
library(DAAG)
library(gstat)
library(lattice)
library(sp)
#
trellis.par.set(theme = col.whitebg())
axis.line <- trellis.par.get("axis.line");axis.line$col <- "black";axis.line$lwd <- 4;
trellis.par.set("axis.line", axis.line)
par.ylab.text <- trellis.par.get("par.ylab.text");par.ylab.text$cex <- 1.4;
trellis.par.set("par.ylab.text", par.ylab.text)
par.xlab.text <- trellis.par.get("par.xlab.text");par.xlab.text$cex <- 1.4;
trellis.par.set("par.xlab.text", par.xlab.text)
fontsize <- trellis.par.get("fontsize");fontsize$text =14;
trellis.par.set("fontsize", fontsize)
axis.text <- trellis.par.get("axis.text");axis.text$cex =1.4;
trellis.par.set("axis.text", axis.text)
# --- Daten einlesen ---
#
d <- read.table("Q2_A_all_mod.dat",header=TRUE)
dat <- d[,c(1,2,3,18)]
cc <- complete.cases(dat)
dat <- dat[cc,]
print("  ")
#
# --- Variogrammanalyse, ohne Trend ---
#
smry <- summary(dat)
print(smry)
#
cut.val = 200
wdth.val = cut.val/10
#
print("--- ohne Trend ---")
g <- variogram(KsRos~1, loc=~X+Y, dat, cutoff=cut.val, width=wdth.val)
par(mfrow=c(2,2))
plot(g$dist,g$gamma,ylim=range(0,max(g$gamma)),xlim=range(0,max(g$dist)),main="ohne Trend")
plot(g$dist,g$np,ylim=range(0,max(g$np)),xlim=range(0,max(g$dist)),main="Anzahl Wertepaare")
pause()
par(mfrow=c(1,1))
mod1 <- vgm(2,"Gau",300,50)
model.1 <- fit.variogram(g, model = mod1,fit.method = 6, fit.sills = TRUE, fit.ranges = TRUE)
pl1 <- plot(g, plot.numbers = TRUE, pch = 15, cex = 0.8, xlim = range(0, 1.1*max(g$dist)), main = "Q2: KsR in A-hor")
pl2 <- plot(g, model=model.1, lwd=4,pch=15,cex=1.5, col="black", xlim = range(0, 1.1*max(g$dist)), main = "Q2: KsR in A-hor")
print(pl1)
pause()
print(pl2)
print(model.1)
#
# --- Ende ---