rm(list=ls())
#
# Setzen der Grundparameter:
n_rnd <- 100
n_zv <- 4
n_hist <- 20
#
# Simulation von Zufallszahlen fr n_zv verschiedene Zufallsvariable:
#Dat <- rlnorm(n_rnd*n_zv,2,0.2)   # lognormal
Dat <- rnorm(n_rnd*n_zv,2,2)     # normal
# Erzeugen einer Datenmatrix mit n_zv Spalten fr die ZV:
Dat_mat <- matrix(Dat, ncol = n_zv, byrow=F) 
# Korrelation der Spaltenvektoren
cor(Dat_mat)
#
# Darstellung als Histogramme:
par(mfrow=c(1,1))
#
par(mfrow=c(2,2))
hist(Dat_mat[,1],breaks=n_hist,col="lightgray",border="red",lwd=2)
hist(Dat_mat[,2],breaks=n_hist,col="lightgray",border="red",lwd=2)
hist(Dat_mat[,3],breaks=n_hist,col="lightgray",border="red",lwd=2)
hist(Dat_mat[,4],breaks=n_hist,col="lightgray",border="red",lwd=2)
#
# Aufgaben:
# 1. Fhren Sie die Simulationen auch mit anderen Verteilungen durch: 
#    lognormal, gleichverteilt, Gamma-Verteilung
# 2. Ab welchem n ndern sich die Verteilungsformen kaum noch?
# 3. Testen Sie die Verteilungen mit qqplot() und qqline()
#    auf Normalverteilung 
#