# Example 5: Netter
x = c( 274,  180,  375,  205,   86,  265,   98,  330,  195,   53,
       430,  372,  236,  157,  370)
y = c(2450, 3254, 3802, 2838, 2347, 3782, 3008, 2450, 2137, 2560,
      4020, 4427, 2660, 2088, 2605)
z = c( 162,  120,  223,  131,   67,  169,   81,  192,  116,   55,
       252,  232,  144,  103,  212)

mreg  = lm(z ~ x + y)
ndata = data.frame(x = c(150, 274, 220, 370), y = c(4000, 2800, 3500, 3100))
zpred = predict(mreg, newdata = ndata, se.fit = F)

open3d()
rgl.bringtotop(stay = T)
plotlm3d(x, y, z,
         surface = T,
         model   = 'z ~ x + y',
         xlab    = 'x',
         ylab    = 'y',
         zlab    = 'z')
spheres3d(x = c(150, 274, 220, 370), y = c(4000, 2800, 3500, 3100), zpred,
          col = 'red', radius = 60)