rm(list=ls())
library(scatterplot3d)
# eine eigene Pausenfunktion:
pause <- function ()
{
    cat("Pause. Press <Enter> to continue...")
    readline()
    invisible()
}
par(mfrow=c(1,1),mar=c(5, 4, 4, 2) + 0.1)
#--------------------------------------------------------------------------
#   Einlesen der Daten
#--------------------------------------------------------------------------
dirname <- "C:\\Users\\Bernd\\Documents\\3_Lehrveranstaltungen\\1_Geokologie_Bsc\\Lehrveranstaltungen\\V2_Geostatistik\\bungen_GS\\GS-Kurs\\6_Empirische Variogramme"
setwd(dirname)
filename <- file.choose()
dat <- read.table(filename,header=F)
names(dat) <- c("X","Y","P","EC","pH","NitCo","NitFlx")
dat$NitFlx <- dat$P*dat$NitCo                             
cln <- 5                  # Spaltennummer
dat <- dat[,c(1,2,cln)]   # Auswahl der Spalte cln
# Bem: dat enthlt jetzt noch genau 3 Spalten: X,Y,und 1 Spalte mit Messwerten 
cc <- complete.cases(dat) # Ermittlung fehlender Werte
dat1 <- dat[cc,]          # Ausschluss fehlender Werte
vartext <- names(dat1)[3] # Spaltenberschrift fr Grafik
ZV <- dat1[,3]            # Verwenden der Spalte 3 fr das Variogramm
#--------------------------------------------------------------------------
#   Plot der Messpunkte
#--------------------------------------------------------------------------
X <- dat1[,1]
Y <- dat1[,2]
plot(X,Y, asp=1, main="Lage der Messpunkte",pch=20,cex=1.2,col="darkgreen",lwd=2)
pause()
#--------------------------------------------------------------------------
# Variogram-Cloud
#--------------------------------------------------------------------------
n <- length(X)
n.count  <- 0
n.pairs  <- (n-1)*n/2         # Anzahl der Paarkombinationen
h.var    <- rep(0,n.pairs)    # Array fr Punktabstnde
semvar   <- rep(0,n.pairs)    # Array fr Semivarianzen
hx.coord <- rep(0,n.pairs)    # Array fr x-Koordinaten von h
hy.coord <- rep(0,n.pairs)    # Array fr y.Koordinaten von h
h.cos    <- rep(0,n.pairs)    # Array fr die Nsse
h.arc    <- rep(0,n.pairs)    # Array fr das Bogenmass
for (i in 1:(n-1)) {
  for (j in (i+1):n) {
    n.count <- n.count + 1
    h.var[n.count]  <- sqrt((X[j]-X[i])^2 + (Y[j]-Y[i])^2)
    semvar[n.count] <- 0.5*(ZV[i]-ZV[j])^2 
    hx.coord[n.count] <- X[j] - X[i]
#    hy.coord[n.count] <- Y[j] - Y[i]
    h.cos[n.count] <-  hx.coord[n.count]/h.var[n.count]
    h.arc[n.count] <-  acos(h.cos[n.count])
}}
#--------------------------------------------------------------------------
# Variogram-empirisch-anisotrop
#--------------------------------------------------------------------------
n.hclass <- 40                    # Anzahl der lag-Klassen
n.arcclass <- 10                  # Anzahl der Winkelklassen
nr.classes <- n.hclass*n.arcclass # Anzahl der Klassen insgesamt
count.class <- rep(0,nr.classes)
count.mat   <- matrix(count.class,byrow=F,ncol=n.arcclass) 
                                  # count.mat fr Anzahlen in den Klassen
sem.mat     <- count.mat          # sem.mat fr die Semivarianzen
HCoord      <- count.mat          # zum Zeichnen der Punkte
ArcCoord    <- count.mat          # zum Zeichnen der Punkte
h.max <- max(h.var)*1.01;
#arc.min <- min(h.arc); 
arc.max <- pi+0.001;
dh   <- h.max/n.hclass
darc <- arc.max/n.arcclass
#
# Klassenmitten
h.class.mean   <- c(-dh/2 + dh*1:n.hclass) # immer nachprfen, ob das stimmt!!
arc.class.mean <- c(-darc/2 + darc*1:n.arcclass) # immer nachprfen, ob das stimmt!!
# Anzahl der Wertepaare in den Klassen
maxh <- max(h.var); maxarc <- max(h.arc)
for (i in 1:length(semvar)) {
  nrh   <- trunc(h.var[i]/dh) + 1        # liefert Klassenindex fr h
  nrarc <- trunc(h.arc[i]/darc) + 1      # liefert Klassenindex fr arc
  count.mat[nrh,nrarc] <- count.mat[nrh,nrarc] + 1
  sem.mat[nrh,nrarc]   <- sem.mat[nrh,nrarc] + semvar[i]
  HCoord[nrh,nrarc]    <- h.class.mean[nrh]
  ArcCoord[nrh,nrarc]  <- arc.class.mean[nrarc]
} 
sem.mat <- sem.mat/count.mat   # fertig!
print(sem.mat)
print(count.mat)
#
# Pixelplot:
image(h.class.mean,arc.class.mean,sem.mat
      ,main=paste("directional variogram: ",vartext)
      ,col = terrain.colors(100))
#
# Contourplot:
filled.contour(h.class.mean,arc.class.mean,sem.mat,color = topo.colors,nlevels=50,
      ,main=paste("directional variogram: ",vartext)
      ,plot.axes={axis(1);axis(2)
      ;contour(h.class.mean,arc.class.mean,sem.mat,nlevels=10,add=T,lwd=1
      ,col="orange", axes=F)
      ;points(HCoord,ArcCoord,col="white",cex=1,lwd=1)
})
#
# Einzelplots der Variogramme
par(mfrow = c(3,2))
for (i in 1:n.arcclass) {
  plot(h.class.mean,sem.mat[,i],
  main=paste(vartext,": arc = ",as.character(round(arc.class.mean[i],3))))
}
#
#   --- Schluss ---
#                                