rm(list=ls())
# Funktion conlim zur Berechnung der Konfidenzlimits
conlim <- function(x = rnorm(10),alpha=0.05){
  n <- length(x)
  xmean <- mean(x)
  xstd <- sqrt(var(x))
  lowalpha <- alpha/2
  upalpha <- 1- lowalpha
  px <- c(qnorm(lowalpha),qnorm(upalpha))
  clu <- c(xmean+px[1]*xstd/sqrt(n),xmean+px[2]*xstd/sqrt(n))
  return(clu)
}
# Schleife mit NExp zuflligen, normalverteilten Daten
# NSample: Stichprobenumfang, Mue: Mittelwert usw.
NExp    <- 40; NSample <- 10; Mue <- 5; SDev <- 3; alpha <- 0.05
dlow <- rep(0,NExp)
dupp <- rep(0,NExp)
for(i in 1: NExp){
  x <- rnorm(NSample,Mue,SDev)
  dlow[i] <- conlim(x, alpha)[1] # da Rckgabe von conlim 2 Elemente enthlt
  dupp[i] <- conlim(x, alpha)[2]
}
cl.frame <- cbind(dlow,dupp)
# Plot ohne Daten
XRange <- range(cl.frame)
plot(cl.frame,xlim=XRange,ylim=c(0,NExp),type="n",xlab="Confidence limits",ylab="Experiment")
# Plot der einzelnen Konfidenzintervalle
delta <- NExp/(NExp-1)
y <- 0
for(i in 1:NExp){
  px <- c(dlow[i],dupp[i])
  py <- c(y,y)
  lines(px,py,lwd=2,type="l")
  y <- y + delta
}
# Plot des "wahren" Erwartungswerts
abline(v=Mue,lwd=3,col="blue")