rm(list=ls())
library(DAAG)
library(gstat)
library(lattice)
library(sp)
library(colorspace)
#
trellis.par.set(theme = col.whitebg())
axis.line <- trellis.par.get("axis.line");axis.line$col <- "black";axis.line$lwd <- 4;
trellis.par.set("axis.line", axis.line)
par.ylab.text <- trellis.par.get("par.ylab.text");par.ylab.text$cex <- 1.2;
trellis.par.set("par.ylab.text", par.ylab.text)
par.xlab.text <- trellis.par.get("par.xlab.text");par.xlab.text$cex <- 1.2;
trellis.par.set("par.xlab.text", par.xlab.text)
fontsize <- trellis.par.get("fontsize");fontsize$text =12;
trellis.par.set("fontsize", fontsize)
axis.text <- trellis.par.get("axis.text");axis.text$cex =1.2;
trellis.par.set("axis.text", axis.text)
# --- Daten einlesen ---
#
d <- read.table("Q2_A_all_mod.dat",header=TRUE)
dat <- d[,c(1,2,3,18)]
cc <- complete.cases(dat)
dat <- dat[cc,]
print("  ")
dat[,1] <- dat[,1]-713500
dat[,2] <- dat[,2]-9560000
print("  ")
#
# --- Variogrammanalyse, ohne Trend ---
#
#
cut.val = 200
wdth.val = cut.val/10
#
print("--- ohne Trend ---")
g <- variogram(KsRos ~ 1, loc=~X+Y, dat, cutoff=cut.val, width=wdth.val)
pause()
#par(mfrow=c(1,1))
mod1 <- vgm(2,"Gau",300,50)
model.1 <- fit.variogram(g, model = mod1,fit.method = 6, fit.sills = TRUE, fit.ranges = TRUE)
pl1 <- plot(g, plot.numbers = TRUE, pch = 15, cex = 0.8, xlim = range(0, 1.1*max(g$dist)), main = "Q2: Ks(Ros) in A-hor")
pl2 <- plot(g, model=model.1, lwd=4,pch=15,cex=1.5, col="black", xlim = range(0, 1.1*max(g$dist)), main = "Q2: Ks (Ros) in A-hor")
#print(pl1)
pause()
par(mfrow=c(2,3))
print(pl2)
print(model.1)
#
# --- Grid file ---
#
ndata <- 100
x <- seq(min(dat$X),max(dat$X),(max(dat$X)-min(dat$X))/(ndata-1))
y <- seq(min(dat$Y),max(dat$Y),(max(dat$Y)-min(dat$Y))/(ndata-1))
rpv <- rep(ndata,ndata)
u<-rep(1:ndata,rpv);v<-rep(1:ndata,ndata)
v <- data.frame(cbind(x[u],y[v]))
dgr <- data.frame(X = v$X1, Y=v$X2)
#
# --- inverse distance map ---
#
#cl <- colors()[seq(280,360,1)]
#cl <- topo.colors(100)
cl <- rainbow(100,start=.7,end=.25)
cts <- 40
x <- krige(KsRos ~ 1, ~ X + Y, dat, dgr, model = NULL)
pl1 <- levelplot(var1.pred~X+Y, x, aspect = "iso",
        main = "inverse distance predictions",contour=FALSE,region=TRUE,pretty=TRUE,labels=FALSE,col.regions=cl,cuts=cts)
print(pl1)
#
# ---  kriging map ---
#
x <- krige(KsRos ~ 1, ~ X + Y, dat, dgr, model = model.1)
pl2 <- levelplot(var1.pred~X+Y, x, aspect = "iso",
        main = "kriging predictions",contour=FALSE,region=TRUE,pretty=TRUE,labels=FALSE,col.regions=cl,cuts=cts)
print(pl2)
#
# --- estimation variance map ---
#
pl3 <- contourplot(var1.var~X+Y, x, aspect = "iso",
        main = "estimation variance",
	  contour=FALSE,region=TRUE,pretty=TRUE,labels=FALSE,col.regions=cl,cuts=cts)
print(pl3)
#
# ---  unconditional simulation map ---
#
xs <- krige(KsRos ~ 1, ~ X + Y, data = NULL, new = dgr, 
     nmax=10, nsim=5, dummy=TRUE, model = model.1, beta = c(mean(x$var1.pred)))
pl4 <- levelplot(sim1~X+Y, xs, aspect = "iso",
        main = "unconditional simulation",contour=FALSE,region=TRUE,pretty=TRUE,labels=FALSE,col.regions=cl,cuts=cts)
print(pl4)
#
# ---  conditional simulation map ---
#
xs <- krige(KsRos ~ 1, ~ X + Y, dat, dgr, model = model.1,
      nmax=10, nsim=5, beta = c(mean(x$var1.pred)))
pl5 <- levelplot(sim1~X+Y, xs, aspect = "iso",
       main = "conditional simulation",contour=FALSE,region=TRUE,pretty=TRUE,labels=FALSE,col.regions=cl,cuts=cts)
print(pl5)
#
# --- Ende ---