\name{tires}
\alias{tires}
\non_function{}
\title{ Treadwear, Traction and Temperature Resistance of popular tires }
\usage{data(tires)}
\description{
  The \code{tires} data frame has 2164 rows and 7 columns.
  
  data set taken from http://www.nhtsa.dot.gov/cars/testing/tirerate/
  which lists
  
  Treadwear (WEAR)
  
  The treadwear grade is a comparative rating based on the wear rate of
  the tire when tested under carefully controlled conditions. For
  example, a tire graded 200 should have its useful tread last twice as
  long as a tire graded 100. However, real world tire tread life, in
  miles, depends on the actual conditions of their use. Tire life is
  affected by variations in driving habits, service practices...such as
  tire rotation, wheel alignment and maintaining proper inflation
  pressure...and differences in road characteristics and climate.
  
  Traction (TRAC)
  
  Traction grades represent the tire's ability to stop on wet pavement
  as measured under controlled conditions on asphalt and concrete test
  surfaces. The traction grades from highest to lowest, are "AA", "A",
  "B" and "C". A tire graded "AA" may have relatively better traction
  performance than a tire graded "A", "B" or "C", based on straight
  ahead braking tests. The grades do not reflect the cornering or
  turning traction performance of the tires.
  
  Temperature Resistance (TEMP)
  
  Temperature grades represent the tire's resistance to heat and its
  ability to dissipate heat when tested under controlled laboratory test
  conditions. Sustained high temperature can cause the tire to
  degenerate and reduce tire life, and excessive temperature can lead to
  sudden tire failure. The temperature grades from highest to lowest are
  "A", "B" and "C". The grade "C" corresponds to the minimum performance
  required by federal safety standard. Grades "B" and "A" represent
  higher levels of performance than the minimum required by law. The
  temperature grade is for a tire that is inflated properly and not
  overloaded. Excessive speed, underinflation or excessive loading,
  either separately on in combination, can cause heat build-up and
  possible tire failure.
}
\format{
  This data frame contains the following columns:
  \describe{
    \item{BRAND}{a factor}
    \item{CONST}{a factor}
    \item{TIRELINE}{a factor}
    \item{SIZE}{a factor}
    \item{TRAC}{a factor}
    \item{TEMP}{a factor}
    \item{WEAR}{a numeric vector}
  }
}
\source{
http://www.nhtsa.dot.gov/cars/testing/tirerate/}
\references{
  Prompted by the Firestone and Ford battle this dataset provides some
  look at tire factors.
}
\examples{
data(tires)
plot(tires[['WEAR']] ~ tires[['TEMP']])
}
\keyword{datasets}
