rm(list=ls())
#--------------------------------------------------------------------------
#   Einstellung von Graphikparametern
#--------------------------------------------------------------------------
par(mfrow=c(1,1))
# eine eigene Pausenfunktion:
pause <- function ()
{
    cat("Pause. Press <Enter> to continue...")
    readline()
    invisible()
}
#--------------------------------------------------------------------------
#   Einlesen der Daten
#--------------------------------------------------------------------------
#setwd("C:\\Dokumente und Einstellungen\\Huwe\\Eigene Dateien\\Lehre\\3_Geokologie_Bsc\\Lehrveranstaltungen\\V2_Geostatisitk\\bungen_GS\\Datenstze")
filename <- file.choose()
dat <- read.table(filename,header=TRUE)
names(dat) <- c("X","Y","P","EC","pH","NitCo","Nr")
cc <- complete.cases(dat)
dat1 <- dat[cc,]
dat1[1:5,]
ZV <- dat1$pH
#--------------------------------------------------------------------------
#   Plot der Messpunkte
#--------------------------------------------------------------------------
X <- dat1[,1]
Y <- dat1[,2]
plot(X,Y,asp=1,main="Lage der Messpunkte",pch=13,cex=1.5,col="blue",lwd=2)
pause()
#--------------------------------------------------------------------------
#   Erstellen eines Grids
#--------------------------------------------------------------------------
ndataX <- 75
ndataY <- 150
x <- seq(min(dat1$X),max(dat1$X),(max(dat1$X)-min(dat1$X))/(ndataX-1))
y <- seq(min(dat1$Y),max(dat1$Y),(max(dat1$Y)-min(dat1$Y))/(ndataY-1))
rpv <- rep(ndataY,ndataX)
u<-rep(1:ndataX,rpv);v<-rep(1:ndataY,ndataX)
w <- data.frame(cbind(x[u],y[v]))
dgr <- data.frame(X = w$X1, Y=w$X2)
plot(w$X1,w$X2,cex=0.2,pch=16,asp=1)
#
#   --- Schluss ---
#