rm(list=ls())
library(lattice)
library(gstat)
#--------------------------------------------------------------------------
#   Einstellung von Graphikparametern
#--------------------------------------------------------------------------
par(mfrow=c(1,1))
trellis.par.set(theme = col.whitebg())
axis.line <- trellis.par.get("axis.line");
axis.line$col <- "black";axis.line$lwd <- 4;
trellis.par.set("axis.line", axis.line)
par.ylab.text <- trellis.par.get("par.ylab.text");par.ylab.text$cex <- 1.4;
trellis.par.set("par.ylab.text", par.ylab.text)
par.xlab.text <- trellis.par.get("par.xlab.text");par.xlab.text$cex <- 1.4;
trellis.par.set("par.xlab.text", par.xlab.text)
fontsize <- trellis.par.get("fontsize");fontsize$text =14;
trellis.par.set("fontsize", fontsize)
axis.text <- trellis.par.get("axis.text");axis.text$cex =1.4;
trellis.par.set("axis.text", axis.text)
# eine eigene Pausenfunktion:
pause <- function ()
{
    cat("Pause. Press <Enter> to continue...")
    readline()
    invisible()
}
#--------------------------------------------------------------------------
#   Einlesen der Daten
#--------------------------------------------------------------------------
#setwd("C:\\Dokumente und Einstellungen\\Huwe\\Eigene Dateien\\Lehre\\3_Geokologie_Bsc\\Lehrveranstaltungen\\V2_Geostatisitk\\bungen_GS\\Datenstze")
filename <- file.choose()
dat <- read.table(filename,header=FALSE)
names(dat) <- c("X","Y","P","EC","pH","NitCo","Nr")
cc <- complete.cases(dat)
dat1 <- dat[cc,]
dat1[1:5,]
ZV <- dat1$pH
#--------------------------------------------------------------------------
#   Plot der Messpunkte
#--------------------------------------------------------------------------
X <- dat1[,1]
Y <- dat1[,2]
plot(X,Y,asp=1,main="Lage der Messpunkte",pch=13,cex=1.5,col="blue",lwd=2)
pause()
#--------------------------------------------------------------------------
#   Erstellen eines Grids
#--------------------------------------------------------------------------
ndataX <- 75
ndataY <- 150
x <- seq(min(dat1$X),max(dat1$X),(max(dat1$X)-min(dat1$X))/(ndataX-1))
y <- seq(min(dat1$Y),max(dat1$Y),(max(dat1$Y)-min(dat1$Y))/(ndataY-1))
rpv <- rep(ndataY,ndataX)
u<-rep(1:ndataX,rpv);v<-rep(1:ndataY,ndataX)
w <- data.frame(cbind(x[u],y[v]))
dgr <- data.frame(X = w$X1, Y=w$X2)
plot(w$X1,w$X2,cex=0.2,pch=16,asp=1)
#--------------------------------------------------------------------------
#   Interpolation durch inverse Distanzwichtung
#   Analysieren Sie den Einfluss der Potenz fr die Wichtungsfaktoren
#--------------------------------------------------------------------------
idw = 1.
idw.out <- idw(pH ~ 1, ~ X + Y,dat1,dgr,idp=idw)
#--------------------------------------------------------------------------
#   levelplot1: mit idw
#--------------------------------------------------------------------------
#cl <- colors()[seq(261,361,1)]
#cl <- topo.colors(100)
cl <- rainbow(100,start=.70,end=.20)
cts <- 40
pl1 <- levelplot(var1.pred~X+Y, idw.out, aspect = "iso",
       main = "inverse distance: function idw (idw=1)",contour=FALSE,region=TRUE,pretty=TRUE,
       labels=FALSE,col.regions=cl,cuts=cts)
print(pl1)
#par(mfrow=c(1,1))
#--------------------------------------------------------------------------
#   levelplot: mit krige
#--------------------------------------------------------------------------
xkrige <- krige(pH ~ 1, ~ X + Y, dat1, dgr, model = NULL)
#cl <- colors()[seq(261,361,1)]
#cl <- topo.colors(100)
cl <- rainbow(100,start=.70,end=.20)
cts <- 40
pl2 <- levelplot(var1.pred~X+Y, xkrige, aspect = "iso",
       main = "inverse distance: function krige",contour=FALSE,region=TRUE,pretty=TRUE,
       labels=FALSE,col.regions=cl,cuts=cts)
print(pl2)
cat("\n","idw.out, idp = ",idw,"\n")
print(idw.out[1:10,],digits=8)
cat("\n","x, ohne idp-Angabe (implizit = 2)\n")
print(xkrige[1:10,],digits=9)
par(mfrow=c(1,1))
#
#  alternativer Contourplot
#
v <- xkrige[,3]
datmat <- matrix(v,byrow=T,nrow=ndataX)
filled.contour(x,y,datmat,asp=1,color = topo.colors,nlevels=50,
, main="Inverse Distanzwichtung"
,plot.axes={axis(1);axis(2)
; contour(x,y,datmat,nlevels=20,add=T,lwd=1,col="brown", axes=F)
; points(X,Y,pch=16,col="white",cex=1,lwd=1)
})
#
#  3D-Plot
#
persp(x,y,datmat, zlim = c(min(ZV),max(ZV)),theta = 30, phi = 20, expand = 0.7, col = "lightblue",
     ltheta = 120, shade = 0.75, ticktype = "detailed",
     xlab = "X-Value", ylab = "\nY-Value", zlab = "ZV-Value", main="Inverse Distanzwichtung",
     r=4,border=NA) -> rotmat
#   Hinzufgen gemessener Datenpunkte
points(trans3d(dat1$X, dat1$Y, ZV, pmat = rotmat), col = 2, pch =16)
#
persp(x,y,datmat, zlim = c(min(ZV),max(ZV)),theta = 30, phi = 20, expand = 0.7, col = "lightblue",
     ltheta = 120, shade = 0.75, ticktype = "detailed",
     xlab = "X-Value", ylab = "\nY-Value", zlab = "ZV-Value", main="Inverse Distanzwichtung",
     r=4,border="lightblue4") -> rotmat
#   Hinzufgen gemessener Datenpunkte
points(trans3d(dat1$X, dat1$Y, ZV, pmat = rotmat), col = 2, pch =16)
#
#   --- Schluss ---
#