rm(list=ls())
par(mfrow=c(3,3))
#-------------------------
# Verteilungen
#-------------------------
n <- 80
#
# Normalverteilung:
#
mue <- 5       # Erwartungswert
sta <- 4       # Standardabweichung
#
from <- mue-2*sta; to <- mue+2*sta;
qx <- seq(from,to,by = ((to - from)/(n - 1)))
dfn <- dnorm(qx,mean=mue,sd=sta)
plot(qx,dfn,col="darkgreen",type="l",lwd=2)
#
from <- 0; to <- 1;
px <- seq(from,to,by = ((to - from)/(n - 1)))
q <- qnorm(px,mean=mue,sd=sta)
plot(px,q,main="Normalverteilung",type="l",lwd=2,col="darkgreen")
#
from <- mue-2*sta; to <- mue+2*sta;
qx <- seq(from,to,by = ((to - from)/(n - 1)))
p <- pnorm(qx,mean=mue,sd=sta)
plot(qx,p,type="l",lwd=2,col="darkgreen")
#
#
# Gleichverteilung:
#
min <- mue - 1.5*sta
max <- mue + 1.5*sta
#
from <- mue-2*sta; to <- mue+2*sta;
qx <- seq(from,to,by = ((to - from)/(n - 1)))
dfu <- dunif(qx,min,max)
plot(qx,dfu,col="darkgreen",type="l",lwd=2)
#
from <- 0; to <- 1;
px <- seq(from,to,by = ((to - from)/(n - 1)))
q <- qunif(px,min,max)
plot(px,q,col="darkgreen",main="Gleichverteilung",type="l",lwd=2)
#
from <- mue-2*sta; to <- mue+2*sta;
qx <- seq(from,to,by = ((to - from)/(n - 1)))
p <- punif(qx,min,max)
plot(qx,p,col="darkgreen",type="l",lwd=2)
#
# Log-Normalverteilung:
#
from <- -1; to <- mue+6*sta;
qx <- seq(from,to,by = ((to - from)/(n - 1)))
dfln <- dlnorm(qx,mean=mue,sd=sta)
plot(qx,dfln,col="darkgreen",type="l",lwd=2)
#
from <- 0; to <- 1;
px <- seq(from,to,by = ((to - from)/(n - 1)))
q <- qlnorm(px,mean=mue,sd=sta)
plot(px,q,col="darkgreen",,main="Log-Normalverteilung",type="l",lwd=2)
#
from <- -1; to <- mue+6*sta;
qx <- seq(from,to,by = ((to - from)/(n - 1)))
p <- plnorm(qx,mean=mue,sd=sta)
plot(qx,p,col="darkgreen",type="l",lwd=2)
#
# --- Skriptende ---