rm(list=ls())
# eine eigene Pausenfunktion:
pause <- function ()
{
    cat("Pause. Press <Enter> to continue...")
    readline()
    invisible()
}
n_loc <- 30 # fr das Einzeichnen der Gebietsgrenzen
cat("Im Graphikfenster History-Hkchen setzen!\n")
cat("-----------------------------------------\n")
par(mfrow = c(1,1))
pause()
#--------------------------------------------------------------------------
#   Einlesen der Daten
#--------------------------------------------------------------------------
#setwd("C:\\Dokumente und Einstellungen\\Huwe\\Eigene Dateien\\Lehre\\3_Geokologie_Bsc\\Lehrveranstaltungen\\V2_Geostatistik\\bungen_GS\\Datenstze\\Bruchsal")
filename <- file.choose()
dat <- read.table(filename,header=F)
names(dat) <- c("X","Y","P","EC","pH","NitCo","NitFlx")
cc <- complete.cases(dat)
dat1 <- dat[cc,]
ZV <- dat1$pH
#--------------------------------------------------------------------------
#   Plot der Messpunkte
#--------------------------------------------------------------------------
X <- dat1[,1]
Y <- dat1[,2]
plot(X,Y, asp=1, main="Lage der Messpunkte",pch=13,cex=1.5,col="blue",lwd=2)
#--------------------------------------------------------------------------
# Digitalisieren der Gebietsgrenzen
#--------------------------------------------------------------------------
locations <- as.data.frame(matrix(1:2*n_loc,byrow = F, ncol=2))
names(locations) <- c("x","y")
locations[1,] <- locator(1)
xmax <- 2500 #max(X)
ymax <- max(Y)
text(xmax,ymax,as.character(1),col="red")
text(xmax,ymax-150,as.character(n_loc),col="green")
for (i in 2:n_loc) {
  locations[i,] <- locator(1)
  lines(locations$x[(i-1):i],locations$y[(i-1):i]);
  xval <- c(xmax-100,xmax+100,xmax+100,xmax-100)
  yval <- c(ymax-100,ymax-100,ymax+100,ymax+100)  
  polygon(xval,yval,col="white",border = "white")
  text(xmax,ymax,as.character(i),col="red")
}
polygon (locations, lwd=3, border = "orange",lty=1)
#--------------------------------------------------------------------------
#   Quadratische Regressionen
#--------------------------------------------------------------------------
par(mfrow=c(1,2))
dat1.lm2 <- lm(ZV~ I(X^2) + I(Y^2) + I(X*Y) + X + Y,dat1)
print(summary(dat1.lm2))
a <- dat1.lm2$residuals
qqnorm(a, main="quadratic trend")
qqline(a,lty=2,col="blue",lwd=2)
#
plot(ZV,dat1.lm2$fitted.values, main="quadratic trend")
par(mfrow=c(1,1))
#   --- Schluss ---
#