rm(list=ls())
# eine eigene Pausenfunktion:
pause <- function ()
{
    cat("Pause. Press <Enter> to continue...")
    readline()
    invisible()
}
n_loc <- 3 # fr das Einzeichnen der Gebietsgrenzen
cat("Im Graphikfenster History-Hkchen setzen!\n")
cat("-----------------------------------------\n")
par(mfrow = c(1,1))
pause()
#--------------------------------------------------------------------------
#   Einlesen der Daten
#--------------------------------------------------------------------------
#setwd("C:\\Dokumente und Einstellungen\\Huwe\\Eigene Dateien\\Lehre\\3_Geokologie_Bsc\\Lehrveranstaltungen\\V2_Geostatistik\\bungen_GS\\Datenstze\\Bruchsal")
filename <- file.choose()
dat <- read.table(filename,header=F)
names(dat) <- c("X","Y","P","EC","pH","NitCo","NitFlx")
cc <- complete.cases(dat)
dat1 <- dat[cc,]
ZV <- dat1$pH
#--------------------------------------------------------------------------
#   Plot der Messpunkte
#--------------------------------------------------------------------------
X <- dat1[,1]
Y <- dat1[,2]
plot(X,Y, asp=1, main="Lage der Messpunkte",pch=13,cex=1.5,col="blue",lwd=2)
#--------------------------------------------------------------------------
# Digitalisieren der Gebietsgrenzen
#--------------------------------------------------------------------------
locations <- as.data.frame(matrix(1:2*n_loc,byrow = F, ncol=2))
names(locations) <- c("x","y")
locations[1,] <- locator(1)
xmax <- 2500 #max(X)
ymax <- max(Y)
text(xmax,ymax,as.character(1),col="red")
text(xmax,ymax-150,as.character(n_loc),col="green")
for (i in 2:n_loc) {
  locations[i,] <- locator(1)
  lines(locations$x[(i-1):i],locations$y[(i-1):i]);
  xval <- c(xmax-100,xmax+100,xmax+100,xmax-100)
  yval <- c(ymax-100,ymax-100,ymax+100,ymax+100)  
  polygon(xval,yval,col="white",border = "white")
  text(xmax,ymax,as.character(i),col="red")
}
polygon (locations, lwd=3, border = "orange",lty=1)
#--------------------------------------------------------------------------
#   Quadratische Regressionen
#--------------------------------------------------------------------------
par(mfrow=c(1,2))
dat1.lm2 <- lm(ZV~ I(X^2) + I(Y^2) + I(X*Y) + X + Y,dat1)
print(summary(dat1.lm2))
a <- dat1.lm2$residuals
qqnorm(a, main="quadratic trend")
qqline(a,lty=2,col="blue",lwd=2)
#
plot(ZV,dat1.lm2$fitted.values, main="quadratic trend")
par(mfrow=c(1,1))
#--------------------------------------------------------------------------
#   3D-Plot fr quadratische Anpassung
#--------------------------------------------------------------------------
n <- length(dat1$X)
#clrs <- colors()[20:(19+n)]
#clrs <- heat.colors(n, alpha = 1)
#clrs <- topo.colors(n, alpha = 1)
#clrs <- cm.colors(n, alpha = 1)
clrs <- rainbow(n, s = 1, v = 1, start = 0, end = max(1,n - 1)/n
,gamma = 1, alpha = 1)
#
par(mfrow=c(1,1))
#
# Erzeugen der X und Y-Werte:
#
NX <- 30; Xmin <- min(dat1$X); Xmax <- max(dat1$X); Xby <- (Xmax-Xmin)/(NX-1)
NY <- 30; Ymin <- min(dat1$Y); Ymax <- max(dat1$Y); Yby <-  (Ymax-Ymin)/(NY-1)
X <- seq(Xmin,Xmax,by=Xby)
Y <- seq(Ymin,Ymax,by=Yby)
ZData <- matrix(1:(NX*NY), nrow=NX)
#Erzeuen der Laufindizes:
iX <- 1:NX
iY <- 1:NY
#
# --- Trendflche der quadratischen Regression ---
#
# Zuweisen der Koeffizienten aus der quadratischen Regression:
a0 <- as.vector(dat1.lm2$coefficients[1])
aX2 <- as.vector(dat1.lm2$coefficients[2])
aY2 <- as.vector(dat1.lm2$coefficients[3])
aXY <- as.vector(dat1.lm2$coefficients[4])
aX  <- as.vector(dat1.lm2$coefficients[5])
aY  <- as.vector(dat1.lm2$coefficients[6])
# Berechnung der Funktionswerte:
fquad <- function(a0,aX,aY,aXY,aX2,aY2,x,y) {
  a0 + aX*x +aY*y+aXY*x*y+aX2*x^2+aY2*y^2
}
for (i in 1:NX) { 
  x <- X[i]; 
  for (j in 1:NY) {
    y <- Y[j]; 
    ZData[i,j] <- fquad(a0,aX,aY,aXY,aX2,aY2,x,y)
  }
}
#
# Perspective plot:
persp(X,Y,ZData, zlim = c(min(ZV),max(ZV)),theta = 30, phi = 20, expand = 0.7, col = "lightblue",
     ltheta = 120, shade = 0.75, ticktype = "detailed",
      xlab = "X-Value", ylab = "\nY-Value", zlab = "ZV-Value", main="quadratischer Trend",
#      r=4,border=NA) -> rotmat
      r=4) -> rotmat
# 
# Ergnzungen:
persp(X,Y,ZData, zlim = c(min(ZV),max(ZV)),theta = 30, phi = 20, expand = 0.7, col = "lightblue",
     ltheta = 120, shade = 0.75, ticktype = "detailed",
      xlab = "X-Value", ylab = "\nY-Value", zlab = "ZV-Value", main="quadratischer Trend",
#      r=4,border=NA) -> rotmat
      r=4) -> rotmat
#
# Einzeichnen der Gebietsgrenzen:
  x <- locations$x;
  y <- locations$y;
  z <- fquad(a0,aX,aY,aXY,aX2,aY2,x,y)
  polygon (trans3d(x, y, z, pmat = rotmat), lwd=3, border = "orange",lty=1)
#
# Hinzufgen gemessener Datenpunkte:
points(trans3d(dat1$X, dat1$Y, ZV, pmat = rotmat), col = 2, pch =16)
for (ind in 1:length(ZV)) {
  x <- c(dat1$X[ind], dat1$X[ind])
  y <- c(dat1$Y[ind], dat1$Y[ind])
  z <- c(ZV[ind], as.real(dat1.lm2$fitted.values[ind]))
  lines (trans3d(x, y, z, pmat = rotmat), lwd=2, col = "gray70",lty=1)
}
#
# Kontrolle der Schtzgleichung
ZD <- a0 + aX2*dat1$X^2 +aY2*dat1$Y^2 +aXY*dat1$X*dat1$Y + aX*dat1$X + aY*dat1$Y
plot(ZD,dat1.lm2$fitted.values)
#   --- Schluss ---
#