rm(list=ls())
library(lattice)
library(sp)
library(gstat)
library(scatterplot3d)
# eine eigene Pausenfunktion:
pause <- function ()
{
    cat("Pause. Press <Enter> to continue...")
    readline()
    invisible()
}
#--------------------------------------------------------------------------
#   Einlesen der Daten
#--------------------------------------------------------------------------
#setwd("C:\\Dokumente und Einstellungen\\Huwe\\Eigene Dateien\\Lehre\\3_Geokologie_Bsc\\Lehrveranstaltungen\\V2_Geostatistik\\bungen_GS\\Datenstze\\Bruchsal")
filename <- file.choose()
dat <- read.table(filename,header=F)
names(dat) <- c("X","Y","P","EC","pH","NitCo","NitFlx")
cc <- complete.cases(dat)
dat1 <- dat[cc,]
dat1[1:5,]
ZV <- dat1$pH
#pause()
#--------------------------------------------------------------------------
#   Plot der Messpunkte
#--------------------------------------------------------------------------
par(mfrow=c(1,1))
X <- dat1[,1]
Y <- dat1[,2]
plot(X,Y,xlim=c(0,max(dat1$X)), main="Lage der Messpunkte\n"
,pch=13,cex=1.5,col="blue",lwd=2,asp=1)
#par(ask=T)
pause()
#--------------------------------------------------------------------------
#  Korrelationsmatrix
#--------------------------------------------------------------------------
korr <- cor(dat1)
print(korr, digits=3)
plot(dat1[,3:7])
#--------------------------------------------------------------------------
# Lineare Regressionen
#--------------------------------------------------------------------------
par(mfrow=c(1,2))
dat1.lm <- lm(ZV~X+Y,dat1)
print(summary(dat1.lm))
a <- dat1.lm$residuals
qqnorm(a, main="linear trend")
qqline(a,lty=2,col="blue",lwd=2)
#
plot(ZV,dat1.lm$fitted.values, main="linear trend")
#--------------------------------------------------------------------------
#   3D-Plots fr lineare Anpassung
#--------------------------------------------------------------------------
n <- length(dat1$X)
#clrs <- colors()[262:(261+n)]
#clrs <- rgb(n:1, 0, 1:n, max = 61)#
#clrs <- heat.colors(n, alpha = 1)
#clrs <- topo.colors(n, alpha = 1)
#clrs <- cm.colors(n, alpha = 1)
clrs <- rainbow(n, s = 1, v = 1, start = 0, end = 1
,gamma = 1, alpha = 1)
#
# --- Farben sind nicht mit Werten codiert!!
#
s3d <- scatterplot3d(dat1$X,dat1$Y,ZV,type="h", highlight.3d=TRUE
,xlab = "X",ylab ="", zlab = "EC"
,angle=55, scale.y=0.7, pch=16, main="EC")
#
s3d <- scatterplot3d(dat1$X,dat1$Y,ZV,type="h", highlight.3d=TRUE,
,xlab = "X",ylab ="", zlab = "EC"
,angle=55, scale.y=0.7, pch=16, main="Linear Regression")
s3d$plane3d(dat1.lm, lty.box="solid",col="blue",lwd=2)

s3d <- scatterplot3d(dat1$X,dat1$Y,ZV,zlim=c(0,1.25*max(dat1.lm$fitted.values))
,xlab = "X",ylab ="", zlab = "EC"
,type="h", highlight.3d=FALSE, angle=55, scale.y=0.7, pch=16, main="EC"
, color=clrs,lwd=1,cex.symbols=2)
s3d <- scatterplot3d(dat1$X,dat1$Y,dat1.lm$fitted.values
,xlab = "X",ylab ="", zlab = "EC"
,zlim=c(0,1.25*max(dat1.lm$fitted.values))
,type="p", highlight.3d=TRUE,angle=55, scale.y=0.7, pch=16, main="Fitted values and residuals")
s3d$plane3d(dat1.lm, lty.box="solid",col="grey",lwd=2)
s3d$points3d(dat1$X,dat1$Y,dat1.lm$residuals, col="green",lwd=2,type="h")
#
#  Indizierung fr Farbcodierung
#
N <- length(dat1$X)
Vmax <- max(dat1$EC)
Vmin <- min(dat1$EC)
DeltaV <- (Vmax-Vmin)/N
Ind <- 1:N
Ind <- floor((dat1$EC-Vmin)/DeltaV)+1
clrspc <- clrs[Ind]
#
#  3D-Plot mit Farbcodierung
#
s3d <- scatterplot3d(dat1$X,dat1$Y,ZV,xlab = "X",ylab ="", zlab = "EC"
,type="h", highlight.3d=FALSE, angle=55, scale.y=0.7, pch=16, main="EC farbcodiert"
, color=clrspc,lwd=1,cex.symbols=2, asp = 1)
#
#  2D-Plot mit Farb- und Grencodierung
#
plot(dat1$X,dat1$Y,,xlim=c(0,max(dat1$X)), xlab = "X",ylab ="Y", pch=16
, main="EC farb- und grencodiert"
, asp=1, col = clrspc, cex = 1 + 0.03*Ind)
#
par(mfrow=c(1,1))
#
#   --- Schluss: noch hinzufgen: bubble-Plot: Farb- und Gren codiert ---
#