rm(list=ls())
library(DAAG)
library(lattice)
library(sp)
library(gstat)
#--------------------------------------------------------------------------
#   Einlesen der Daten
#--------------------------------------------------------------------------
#setwd("C:\\Dokumente und Einstellungen\\Huwe\\Eigene Dateien\\Lehre\\3_Geokologie_Bsc\\Lehrveranstaltungen\\V2_Geostatistik\\bungen_GS\\Datenstze\\Bruchsal")
filename <- file.choose()
dat <- read.table(filename,header=F)
names(dat) <- c("X","Y","P","EC","pH","NitCo","NitFlx")
dat2 <- dat
dat2[1:5,]
cc <- complete.cases(dat)
dat1 <- dat[cc,]
ZV <- dat1$pH
#pause()
#--------------------------------------------------------------------------
#   Plot der Messpunkte
#--------------------------------------------------------------------------
par(mfrow = c(1,1))
X <- dat2[,1]
Y <- dat2[,2]
plot(X,Y, asp=1, main="Lage der Messpunkte",pch=13,cex=1.5,col="blue",lwd=2)
#par(ask=T)
#pause()
#--------------------------------------------------------------------------
#  Korrelationsmatrix
#--------------------------------------------------------------------------
korr <- cor(dat1)
print(korr, digits=3)
plot(dat1[,3:7])
#--------------------------------------------------------------------------
#   Quadratische Regressionen
#--------------------------------------------------------------------------
par(mfrow=c(1,2))
dat1.lm1 <- lm(ZV~X + Y,dat1)
print(summary(dat1.lm1))
a <- dat1.lm1$residuals
qqnorm(a, main="linear trend")
qqline(a,lty=2,col="blue",lwd=2)
#
plot(ZV,dat1.lm1$fitted.values, main="linear trend")
#--------------------------------------------------------------------------
#   3D-Plot fr quadratische Anpassung
#--------------------------------------------------------------------------
n <- length(dat1$X)
#clrs <- colors()[20:(19+n)]
#clrs <- heat.colors(n, alpha = 1)
#clrs <- topo.colors(n, alpha = 1)
#clrs <- cm.colors(n, alpha = 1)
clrs <- rainbow(n, s = 1, v = 1, start = 0, end = max(1,n - 1)/n
,gamma = 1, alpha = 1)
#
par(mfrow=c(1,1))
#
# Erzeugen der X und Y-Werte:
#
NX <- 30; Xmin <- min(dat1$X); Xmax <- max(dat1$X); Xby <- (Xmax-Xmin)/(NX-1)
NY <- 30; Ymin <- min(dat1$Y); Ymax <- max(dat1$Y); Yby <-  (Ymax-Ymin)/(NY-1)
X <- seq(Xmin,Xmax,by=Xby)
Y <- seq(Ymin,Ymax,by=Yby)
ZData <- matrix(1:(NX*NY), nrow=NX)
#Erzeugen der Laufindizes:
iX <- 1:NX
iY <- 1:NY
#
# --- Trendflche der quadratischen Regression ---
#
# Zuweisen der Koeffizienten aus der quadratischen Regression:
a0 <- as.vector(dat1.lm1$coefficients[1])
aX <- as.vector(dat1.lm1$coefficients[2])
aY <- as.vector(dat1.lm1$coefficients[3])
# Berechnung der Funktionswerte:
flin <- function(a0,aX,aY,x,y) {a0 + aX*x +aY*y}
for (i in 1:NX) { x <- X[i]; for (j in 1:NY) {y <- Y[j]; ZData[i,j] <- flin(a0,aX,aY,x,y)}}
# Perspective plot:
persp(X,Y,ZData, zlim = c(min(ZV),max(ZV)),theta = 30, phi = 20, expand = 0.7, col = "lightblue",
     ltheta = 120, shade = 0.75, ticktype = "detailed",
      xlab = "X-Value", ylab = "\nY-Value", zlab = "ZV-Value", main="linearer Trend",
      r=4,border=NA) -> rotmat
#   Hinzufgen gemessener Datenpunkte
points(trans3d(dat1$X, dat1$Y, ZV, pmat = rotmat), col = 2, pch =16)
for (ind in 1:length(ZV)) {
  x <- c(dat1$X[ind], dat1$X[ind])
  y <- c(dat1$Y[ind], dat1$Y[ind])
  z <- c(ZV[ind], as.real(dat1.lm1$fitted.values[ind]))
  lines (trans3d(x, y, z, pmat = rotmat), lwd=2, col = "black",lty=1)
}
# Kontrolle der Schtzgleichung
ZD <- a0 + aX*dat1$X + aY*dat1$Y
plot(ZD,dat1.lm1$fitted.values)

#   --- Schluss ---
#