# Example 6: Generating data
library(AlgDesign)
dad   = gen.factorial(levels = 5, nVars = 2, varNames = c('x', 'y'))
dad$z = with(dad, 1 + 2*x + 3*y - 0.5*x^2 - 0.8*y^2 + 1*x*y)
with(dad, plotlm3d(x, y, z,
                   surface       = T,
                   model         = c('z ~ x + y + I(x^2) + I(y^2) + I(x*y)',
                                     'z ~ x + y + I(x^2) + I(y^2)'),
                   xlab          = 'x',
                   ylab          = 'y',
                   zlab          = 'z',
                   sphere.factor = 3,
                   model.summary = T))