rm(list=ls())
library(scatterplot3d)
# eine eigene Pausenfunktion:
pause <- function ()
{
    cat("Pause. Press <Enter> to continue...")
    readline()
    invisible()
}
par(mfrow = c(1,1))
pause()
#--------------------------------------------------------------------------
#   Einlesen der Daten
#--------------------------------------------------------------------------
#setwd("C:\\Dokumente und Einstellungen\\Huwe\\Eigene Dateien\\Lehre\\3_Geokologie_Bsc\\Lehrveranstaltungen\\V2_Geostatistik\\bungen_GS\\Datenstze\\Bruchsal")
filename <- file.choose()
dat <- read.table(filename,header=F)
names(dat) <- c("X","Y","P","EC","pH","NitCo","NitFlx")
cc <- complete.cases(dat)
dat1 <- dat[cc,]
ZV <- dat1$pH
#--------------------------------------------------------------------------
#   Plot der Messpunkte
#--------------------------------------------------------------------------
X <- dat1[,1]
Y <- dat1[,2]
plot(X,Y, asp=1, main="Lage der Messpunkte",pch=20,cex=1.3,col="darkgreen",lwd=2)
#--------------------------------------------------------------------------
# Variogram-Cloud
#--------------------------------------------------------------------------
par(mfrow=c(1,1),mar=c(5, 4, 4, 2) + 0.1)
n <- length(X)
n.count <- 0
n.pairs <- (n-1)*n/2         # Anzahl der Paarkombinationen
semvar  <- rep(0,n.pairs)    # Array fr Semivarianzen
hx.coord <- rep(0,n.pairs)   # Array fr x-Koordinaten von h
hy.coord <- rep(0,n.pairs)   # Array fr y.Koordinaten von h
for (i in 1:n) {
  for (j in 1:n) {
    if(i!=j) {
      n.count <- n.count + 1
      semvar[n.count] <- 0.5*(ZV[i]-ZV[j])^2 
      hx.coord[n.count] <- X[j] - X[i]
      hy.coord[n.count] <- Y[j] - Y[i]
    }
}}
#
# scatterplot
n.clrs <- length(hx.coord)
h.clrs <- rep(0,n.clrs)      # Array fr Farben
semmax <- max(semvar)
for (i in 1:n.clrs){
  scf <- semvar[i]/semmax
  h.clrs[i] <- rgb(scf,0.5*(1-scf),0)
}
color <- h.clrs
scatterplot3d(hx.coord,hy.coord,semvar,color,box=F,angle=40,highlight.3d=F,
col.grid="lightblue",pch=20,type="h",,main="variogram-cloud-2D") # p: nur Punkte; pch=NA: nur Linien
#
#   --- Schluss ---
#