rm(list=ls())
library(scatterplot3d)
# eine eigene Pausenfunktion:
pause <- function ()
{
    cat("Pause. Press <Enter> to continue...")
    readline()
    invisible()
}
#--------------------------------------------------------------------------
#   Einlesen der Daten
#--------------------------------------------------------------------------
dirname <- "C:\\Users\\Bernd\\Documents\\3_Lehrveranstaltungen\\1_Geokologie_Bsc\\Lehrveranstaltungen\\V2_Geostatistik\\bungen_GS\\GS-Kurs\\6_Empirische Variogramme"
setwd(dirname)
filename <- file.choose()
dat <- read.table(filename,header=F)
names(dat) <- c("X","Y","P","EC","pH","NitCo","NitFlx")
dat$NitFlx <- dat$P*dat$NitCo                             
cln <- 5                  # Spaltennummer
dat <- dat[,c(1,2,cln)]   # Auswahl der Spalte cln
# Bem: dat enthlt jetzt noch genau 3 Spalten: X,Y,und 1 Spalte mit Messwerten 
cc <- complete.cases(dat) # Ermittlung fehlender Werte
dat1 <- dat[cc,]          # Ausschluss fehlender Werte
vartext <- names(dat1)[3] # Spaltenberschrift fr Grafik
S <- min(dat1[,3])+(max(dat1[,3])-min(dat1[,3]))*c(0:8)/8
par(mfrow=c(3,3))
#--------------------------------------------------------------------------
# Beginn: Schleife ber alle Schwellenwerte
#--------------------------------------------------------------------------
for (k in 1:length(S)) {
#
# Erzeugung der Indikatorvariablen:
ZV <- dat1[,3]            # Verwenden der Spalte 3 fr das Variogramm
ZV[ZV[]<=S[k]] <- 0
ZV[ZV[]>0] <- 1
#--------------------------------------------------------------------------
#   Plot der Messpunkte
#--------------------------------------------------------------------------
X <- dat1[,1]
Y <- dat1[,2]
#plot(X,Y, asp=1, main="Lage der Messpunkte",pch=20,cex=1.2,col="darkgreen",lwd=2)
#--------------------------------------------------------------------------
# Variogram-Cloud
#--------------------------------------------------------------------------
#par(mfrow=c(1,1),mar=c(5, 4, 4, 2) + 0.1)
n <- length(X)
n.count <- 0
n.pairs <- (n-1)*n/2         # Anzahl der Paarkombinationen
h.var   <- rep(0,n.pairs)    # Array fr Punktabstnde
semvar  <- rep(0,n.pairs)    # Array fr Semivarianzen
for (i in 1:(n-1)) {
  for (j in (i+1):n) {
    n.count <- n.count + 1
    h.var[n.count]  <- sqrt((X[j]-X[i])^2 + (Y[j]-Y[i])^2)
    semvar[n.count] <- 0.5*(ZV[i]-ZV[j])^2 
}}
#--------------------------------------------------------------------------
# Variogram-empirisch-isotrop
#--------------------------------------------------------------------------
n.hclass <- 20
count.class <- rep(0,n.hclass)
sem.class   <- rep(0,n.hclass)
dh <- 1.001*max(h.var)/n.hclass
# Klassenmitten
h.class.mean <- c(-dh/2 + dh*1:n.hclass) # immer nachprfen, ob das stimmt!!
# Anzahl der Wertepaare in den Klassen
for (i in 1:length(semvar)) {
  nr <- trunc(h.var[i]/dh) + 1           # liefert Index fr lag-Klassen
  count.class[nr] <- count.class[nr] + 1
  sem.class[nr]   <- sem.class[nr] + semvar[i]
} 
semvar.class <- sem.class/count.class
#
# Plots:
nvar.max <- trunc(0.5*n.hclass)
plot(h.class.mean[1:nvar.max],semvar.class[1:nvar.max],
ylim=c(0,max(semvar.class)),pch=15,col="blue",
xlab="lag",ylab="semivariance",main=paste(vartext,": Schwelle: ",as.character(S[k])))
}
#--------------------------------------------------------------------------
# Ende: Schleife ber alle Schwellenwerte
#--------------------------------------------------------------------------
#
#   --- Schluss ---
# 