rm(list=ls())
library(scatterplot3d)
# eine eigene Pausenfunktion:
pause <- function ()
{
    cat("Pause. Press <Enter> to continue...")
    readline()
    invisible()
}
par(mfrow = c(1,1))
pause()
#--------------------------------------------------------------------------
#   Einlesen der Daten
#--------------------------------------------------------------------------
#setwd("C:\\Dokumente und Einstellungen\\Huwe\\Eigene Dateien\\Lehre\\3_Geokologie_Bsc\\Lehrveranstaltungen\\V2_Geostatistik\\bungen_GS\\Datenstze\\Bruchsal")
filename <- file.choose()
dat <- read.table(filename,header=F)
names(dat) <- c("X","Y","P","EC","pH","NitCo","NitFlx")
cc <- complete.cases(dat)
dat1 <- dat[cc,]
ZV <- dat1$pH
#--------------------------------------------------------------------------
#   Plot der Messpunkte
#--------------------------------------------------------------------------
X <- dat1[,1]
Y <- dat1[,2]
plot(X,Y, asp=1, main="Lage der Messpunkte",pch=20,cex=1.3,col="darkgreen",lwd=2)
#--------------------------------------------------------------------------
# Variogram-Cloud
#--------------------------------------------------------------------------
par(mfrow=c(1,1),mar=c(5, 4, 4, 2) + 0.1)
n <- length(X)
n.count <- 0
n.pairs <- (n-1)*n/2         # Anzahl der Paarkombinationen
h.var   <- rep(0,n.pairs)    # Array fr Punktabstnde
semvar  <- rep(0,n.pairs)    # Array fr Semivarianzen
for (i in 1:(n-1)) {
  for (j in (i+1):n) {
    n.count <- n.count + 1
    h.var[n.count]  <- sqrt((X[j]-X[i])^2 + (Y[j]-Y[i])^2)
    semvar[n.count] <- 0.5*(ZV[i]-ZV[j])^2 
}}
plot(h.var,semvar,main="variogram-cloud")
#
#   --- Schluss ---
#