#--------------------------------------------------------------------------
# Aufgabe: Berechnung des empirischen anisotropen Variogramms
#          fr eine ausgewhlte Variable des eingelesenen dataframes
#--------------------------------------------------------------------------
rm(list=ls())
library(scatterplot3d)
# eine eigene Pausenfunktion:
pause <- function ()
{
    cat("Pause. Press <Enter> to continue...")
    readline()
    invisible()
}
par(mfrow = c(1,1))
#--------------------------------------------------------------------------
#   Einlesen der Daten
#--------------------------------------------------------------------------
dirname <- "C:\\Users\\Bernd\\Documents\\3_Lehrveranstaltungen\\1_Geokologie_Bsc\\Lehrveranstaltungen\\V2_Geostatistik\\bungen_GS\\GS-Kurs\\6_Empirische Variogramme"
setwd(dirname)
filename <- file.choose()
dat <- read.table(filename,header=F)
names(dat) <- c("X","Y","P","EC","pH","NitCo","NitFlx")
dat$NitFlx <- dat$P*dat$NitCo                             
cln <- 3                  # Spaltennummer
dat <- dat[,c(1,2,cln)]   # Auswahl der Spalte cln
# Bem: dat enthlt jetzt noch genau 3 Spalten: X,Y,und 1 Spalte mit Messwerten 
cc <- complete.cases(dat) # Ermittlung fehlender Werte
dat1 <- dat[cc,]          # Ausschluss fehlender Werte
vartext <- names(dat1)[3] # Spaltenberschrift fr Grafik
ZV <- dat1[,3]            # Verwenden der Spalte 3 fr das Variogramm
#--------------------------------------------------------------------------
#   Plot der Messpunkte
#--------------------------------------------------------------------------
X <- dat1[,1]
Y <- dat1[,2]
plot(X,Y, asp=1, main="Lage der Messpunkte",pch=20,cex=1.2,col="darkgreen",lwd=2)
pause()
#--------------------------------------------------------------------------
# Variogram-Cloud
#--------------------------------------------------------------------------
par(mfrow=c(1,1),mar=c(5, 4, 4, 2) + 0.1)
n <- length(X)
n.count <- 0
n.pairs <- (n-1)*n/2         # Anzahl der Paarkombinationen
semvar  <- rep(0,n.pairs)    # Array fr Semivarianzen
hx.coord <- rep(0,n.pairs)   # Array fr x-Koordinaten von h
hy.coord <- rep(0,n.pairs)   # Array fr y.Koordinaten von h
for (i in 1:n) {
  for (j in 1:n) {
    if(i!=j) {
      n.count <- n.count + 1
      semvar[n.count] <- 0.5*(ZV[i]-ZV[j])^2 
      hx.coord[n.count] <- X[j] - X[i]
      hy.coord[n.count] <- Y[j] - Y[i]
    }
}}
#--------------------------------------------------------------------------
# Variogram-empirisch-anisotrop
#--------------------------------------------------------------------------
n.hxclass <- 20
n.hyclass <- 20
nr.classes <- n.hxclass*n.hyclass
count.class <- rep(0,nr.classes)
count.mat   <- matrix(count.class,byrow=F,ncol=n.hxclass)
sem.mat     <- count.mat
XCoord      <- count.mat # zum Zeichnen der Punkte
YCoord      <- count.mat # zum Zeichnen der Punkte
hx.min <- 1.001*min(hx.coord); hx.max <- 1.001*max(hx.coord);
hy.min <- 1.001*min(hy.coord); hy.max <- 1.01*max(hy.coord);
dhx <- ((hx.max-hx.min))/n.hxclass
dhy <- ((hy.max-hy.min))/n.hyclass
#
# Klassenmitten:
hx.class.mean <- c(hx.min + dhx/2 + dhx*1:(n.hxclass)+1) # immer nachprfen, ob das stimmt!!
hy.class.mean <- c(hy.min + dhy/2 + dhy*1:(n.hyclass)+1) # immer nachprfen, ob das stimmt!!
#stop()
#
# Zhlen der Wertepaare in den Klassen:
for (i in 1:length(semvar)) {
  nrx <- trunc((hx.coord[i]-hx.min)/dhx) + 1
  nry <- trunc((hy.coord[i]-hy.min)/dhy) + 1
  # + 1 auf der rechten Seite ist notwendig weil z.B. trunc(0.5) = 0 ergibt,
  # aber in die 1. Klasse eingeordnet werden soll
  count.mat[nrx,nry] <- count.mat[nrx,nry] + 1
  sem.mat[nrx,nry]   <- sem.mat[nrx,nry] + semvar[i]
  XCoord[nrx,nry]    <- hx.class.mean[nrx]
  YCoord[nrx,nry]    <- hy.class.mean[nry]
} 
sem.mat <- sem.mat/count.mat
#
# Pixelplot:
image(hx.class.mean,hy.class.mean,sem.mat,asp=1,
      main=paste("2D-variogram: ",vartext),
      col = terrain.colors(100))
#
# Contourplot:
filled.contour(hx.class.mean,hy.class.mean,sem.mat,asp=1,color = topo.colors,nlevels=50,
, main=paste("2D-variogram: ",vartext)
, plot.axes={axis(1);axis(2)
; contour(hx.class.mean,hy.class.mean,sem.mat,nlevels=10,add=T,lwd=1,
  col="orange", axes=F)
; points(XCoord,YCoord,col="white",cex=1,lwd=1)
})
#
#   --- Schluss ---
#