rm(list=ls())
#--------------------------------------------------------------------------
#   Laden der packages
#--------------------------------------------------------------------------
library(lattice)
library(sp)
library(gstat)
# eine eigene Pausenfunktion:
pause <- function ()
{
    cat("Pause. Press <Enter> to continue...")
    readline()
    invisible()
}
#--------------------------------------------------------------------------
#   Voreinstellungen
#--------------------------------------------------------------------------
# Festsetzen von Graphikparametern fr das Trellis-package
trellis.par.set(theme = col.whitebg())
axis.line <- trellis.par.get("axis.line");
axis.line$col <- "black";axis.line$lwd <- 4;
trellis.par.set("axis.line", axis.line)
#
fontsize <- trellis.par.get("fontsize");fontsize$text =10;
trellis.par.set("fontsize", fontsize)
par.ylab.text <- trellis.par.get("par.ylab.text");par.ylab.text$cex <- 1.8;
trellis.par.set("par.ylab.text", par.ylab.text)
par.xlab.text <- trellis.par.get("par.xlab.text");par.xlab.text$cex <- 1.8;
trellis.par.set("par.xlab.text", par.xlab.text)
axis.text <- trellis.par.get("axis.text");axis.text$cex =1.4;
trellis.par.set("axis.text", axis.text)
par.main.text <- trellis.par.get("par.main.text");par.main.text$cex =2.0;
trellis.par.set("par.main.text", par.main.text)
#
plot.symbol <- trellis.par.get("plot.symbol");
plot.symbol$col ="blue"
plot.symbol$pch =16
plot.symbol$fill = "blue"
plot.symbol$cex = 0.8
trellis.par.set("plot.symbol", plot.symbol)
#--------------------------------------------------------------------------
#   Einlesen der Daten
#--------------------------------------------------------------------------
filename <- file.choose()
dat <- read.table(filename,header=TRUE)
names(dat) <- c("X","Y","P","EC","pH","NitCo","NitFlx")
cc <- complete.cases(dat)
dat1 <- dat[cc,]
coordinates(dat1) <- c("X", "Y")
ZV <- dat1$pH
#--------------------------------------------------------------------------
#  Emp. Variogramm
#--------------------------------------------------------------------------
cut.val = 4000
wdth.val = cut.val/20
v.dir <- variogram(ZV~1, dat1, alpha=c(0,30,60,90,120,150),
         cutoff=cut.val, width=wdth.val)
a <- plot(v.dir, plot.numbers = F, pch = 15, cex = 1.0, col="blue"
, xlim = range(0, 1.1*max(v.dir$dist)), main = "Empirisches Variogramm")
print(a)
pause()
#--------------------------------------------------------------------------
# Anpassung eines sphrischen Variogrammmodells mit nugget
#--------------------------------------------------------------------------
v.anis <- vgm(0.3, "Sph", 800,0.1, anis = c(45,0.9))
plot(v.dir, v.anis)
pause()
#--------------------------------------------------------------------------
# Anpassung eines Gauss'schen Variogrammmodells mit nugget
#--------------------------------------------------------------------------
v.anis <- vgm(0.3, "Gau", 800,0.1, anis = c(45,0.9))
plot(v.dir, v.anis)
pause()
#--------------------------------------------------------------------------
# Variogramm-Karte
#--------------------------------------------------------------------------
plot(variogram(ZV~1, dat1, map=TRUE, cutoff=cut.val, width=wdth.val))