rm(list=ls())
library(sp)
library(gstat)
# eine eigene Pausenfunktion:
pause <- function ()
{
    cat("Pause. Press <Enter> to continue...")
    readline()
    invisible()
}
#
#--------------------------------------------------------------------------
#   Einlesen der Daten
#--------------------------------------------------------------------------
filename <- file.choose()
dat <- read.table(filename,header=TRUE)
names(dat) <- c("X","Y","P","EC","pH","NitCo","NitFlx")
dat <- dat
dat[1:5,]
cc <- complete.cases(dat)
dat <- dat[cc,c(1,2,5)]
names(dat) <- c("X","Y","ZV")
dat1 <- dat
#--------------------------------------------------------------------------
#  variogram estimation: confidence interval - standard
#--------------------------------------------------------------------------
varest.ran <- function(n,dat2,dat1,ZV)
{
  iv <- sample(1:n,replace=FALSE)
  dat2$ZV <- dat1$ZV[iv]
  vg <- variogram(ZV~1,dat2)
  vg
}
#
par(mfrow=c(1,1))
coordinates(dat1) <- c("X", "Y")
vg1 <- variogram(ZV~1,dat1)
plot(vg1$dist,vg1$gamma,ylim = c(0,1.5*max(vg1$gamma)),pch="",main="Standard variogram: 5% KI")
lines(vg1$dist,vg1$gamma,lty=1,pch="15",lwd=4,col="blue")
pause()#
n <- length(dat[,1])
dat2 <- dat
coordinates(dat2) <- c("X", "Y")
#
nran <- 80
numcol <- length(vg1[,1])
ranvg <- matrix(1:(nran*numcol),byrow=T, nrow=nran)
KI_up <- 1:numcol
KI_lw <- 1:numcol
#
for (k in 1:nran) {
  vg <- varest.ran(n,dat2,dat1,ZV)
  lines(vg$dist,vg$gamma,lty=1,pch="",lwd=2,col="lightgray")
  ranvg[k,] <- vg$gamma
}
lines(vg1$dist,vg1$gamma,lty=1,pch="15",lwd=4,col="blue")
#
for (k in 1:numcol) {
  KI_up[k] <- quantile(ranvg[,k],0.975)
  KI_lw[k] <- quantile(ranvg[,k],0.025)
}
lines(vg1$dist,KI_up,lty=1,pch="15",lwd=4,col="black")
lines(vg1$dist,KI_lw,lty=1,pch="15",lwd=4,col="black")

#--------------------------------------------------------------------------
#  variogram estimation: confidence interval robust (CRESSIE = TRUE)
#--------------------------------------------------------------------------
varest.ran.robust <- function(n,dat2,dat1,ZV)
{
  iv <- sample(1:n,replace=FALSE)
  dat2$ZV <- dat1$ZV[iv]
  vg <- variogram(ZV~1,dat2,cressie=TRUE)
  vg
}
#
par(mfrow=c(1,1))
#coordinates(dat1) <- c("X", "Y")
vg1 <- variogram(ZV~1,dat1,cressie = TRUE)
plot(vg1$dist,vg1$gamma,ylim = c(0,1.5*max(vg1$gamma)),pch="",main="Robust variogram: 5% KI")
lines(vg1$dist,vg1$gamma,lty=1,pch="15",lwd=4,col="blue")
#
n <- length(dat[,1])
dat3 <- dat
coordinates(dat3) <- c("X", "Y")
#
for (k in 1:nran) {
  vg <- varest.ran.robust(n,dat3,dat1,ZV);
  lines(vg$dist,vg$gamma,lty=1,pch="",lwd=2,col="lightgray")
  ranvg[k,] <- vg$gamma
}
lines(vg1$dist,vg1$gamma,lty=1,pch="15",lwd=4,col="blue")
#
for (k in 1:numcol) {
  KI_up[k] <- quantile(ranvg[,k],0.975)
  KI_lw[k] <- quantile(ranvg[,k],0.025)
}
lines(vg$dist,KI_up,lty=1,pch="15",lwd=4,col="black")
lines(vg$dist,KI_lw,lty=1,pch="15",lwd=4,col="black")
#--------------------------------------------------------------------------
#  variogram estimation: random data assignments (CRESSIE = TRUE)
#--------------------------------------------------------------------------
par(mfrow=c(3,3))
for (k in 1:9) {
  vg1 <- variogram(ZV~1,dat1,cressie = TRUE)
  plot(vg1$dist,vg1$gamma,ylim = c(0,1.5*max(vg1$gamma)),pch="",main="Random permutations")
  lines(vg1$dist,vg1$gamma,lty=1,pch="15",lwd=4,col="lightgray")
  vg <- varest.ran.robust(n,dat3,dat1,ZV);lines(vg$dist,vg$gamma,lty=1,pch="",lwd=2,col="black")
  vg <- varest.ran.robust(n,dat3,dat1,ZV);lines(vg$dist,vg$gamma,lty=1,pch="",lwd=2,col="blue")
  vg <- varest.ran.robust(n,dat3,dat1,ZV);lines(vg$dist,vg$gamma,lty=1,pch="",lwd=2,col="green")
  vg <- varest.ran.robust(n,dat3,dat1,ZV);lines(vg$dist,vg$gamma,lty=1,pch="",lwd=2,col="red")
}

#   Schluss