rm(list=ls())
#--------------------------------------------------------------------------
#   Laden der packages
#--------------------------------------------------------------------------
library(sp)
library(gstat)
# eine eigene Pausenfunktion:
pause <- function ()
{
    cat("Pause. Press <Enter> to continue...")
    readline()
    invisible()
}
#--------------------------------------------------------------------------
#   Voreinstellungen
#--------------------------------------------------------------------------
par(mfrow=c(1,1))
#--------------------------------------------------------------------------
#   Einlesen der Daten, Trainings- und Validierungsdatensatz
#--------------------------------------------------------------------------
filename <- file.choose()
dat <- read.table(filename,header=TRUE)
names(dat) <- c("X","Y","P","EC","pH","NitCo","NitFlx")
cc <- complete.cases(dat)
dat1 <- dat[cc,]
CrossCor <- 1:100 #Vektor zur Aufnahme der Korrelationskoeffizienten
N.valid <- 10
N.model <- length(dat1[,1]) - N.valid
if (N.model <= 0) {cat("N.model <= 0"); stop()}
for (i in 1:100) {
    sel.valid <- sample(1:length(dat1[,1]), N.model)# Zufallsauswahl
    dat1.model <- dat1[sel.valid,]# Trainingsdatensatz
    dat1.valid <- dat1[-sel.valid,]# Validierungsdatensatz
    ZV.model <- dat1.model$pH
    ZV.valid <- dat1.valid$pH
    #--------------------------------------------------------------------------
    #  Emp. Variogramm
    #--------------------------------------------------------------------------
    cut.val = 2000
    wdth.val = cut.val/10
    vg.model <- variogram(ZV.model~1, loc = ~X+Y, dat1.model, cutoff = cut.val, width = wdth.val)
    #--------------------------------------------------------------------------
    # Anpassung eines sphrischen Variogrammmodells mit nugget
    #--------------------------------------------------------------------------
    mod1 <- vgm(0, "Gau", 500,1)
    v.fit <- fit.variogram(vg.model, model=mod1, fit.method=7, fit.sills=TRUE, fit.ranges=TRUE)
    #--------------------------------------------------------------------------
    #   Ordinary Kriging  auf dem Trainingsdatensatz
    #--------------------------------------------------------------------------
    ZV.okr <- krige(ZV.model ~ 1, ~ X + Y, dat1.model, dat1.valid, model = v.fit)
    ZV.pred <- ZV.okr$var1.pred
    resid.kr <- (ZV.pred - ZV.valid)
    crossvalid <- data.frame(ZV.pred,ZV.valid,resid.kr)
    crossvalid
    summary(resid.kr)
    CrossCor[i] <- cor(ZV.pred,ZV.valid)
}
summary(CrossCor)
hist(CrossCor)