rm(list=ls())
#--------------------------------------------------------------------------
#   Laden der packages
#--------------------------------------------------------------------------
library(sp)
library(gstat)
# eine eigene Pausenfunktion:
pause <- function ()
{
    cat("Pause. Press <Enter> to continue...")
    readline()
    invisible()
}
#--------------------------------------------------------------------------
#   Voreinstellungen
#--------------------------------------------------------------------------
par(mfrow=c(1,1))
#--------------------------------------------------------------------------
#   Einlesen der Daten, Trainings- und Validierungsdatensatz
#--------------------------------------------------------------------------
filename <- file.choose()
dat <- read.table(filename,header=TRUE)
names(dat) <- c("X","Y","P","EC","pH","NitCo","NitFlx")
cc <- complete.cases(dat)
dat1 <- dat[cc,]
N.valid <- 1
N.model <- length(dat1[,1]) - N.valid
ZVpred <- 1: length(dat1[,1])
ZVvalid <- 1: length(dat1[,1])
# Schleife fr leave one out
for (i in 1:length(dat1[,1])) {
    sel.valid <- sample(1:length(dat1[,1]), N.model)
    dat1.model <- dat1[-i,]# Trainingsdatensatz: n-1
    dat1.valid <- dat1[i,]# Validierungsdatensatz: hier nur 1 Wert
    ZV.model <- dat1.model$pH
    ZV.valid <- dat1.valid$pH
    #--------------------------------------------------------------------------
    #  Emp. Variogramm
    #--------------------------------------------------------------------------
    cut.val = 2000
    wdth.val = cut.val/10
    vg.model <- variogram(ZV.model~1, loc = ~X+Y, dat1.model, cutoff = cut.val, width = wdth.val)
    #--------------------------------------------------------------------------
    # Anpassung eines sphrischen Variogrammmodells mit nugget
    #--------------------------------------------------------------------------
    mod1 <- vgm(0, "Gau", 500,1)
    v.fit <- fit.variogram(vg.model, model=mod1, fit.method=7, fit.sills=TRUE, fit.ranges=TRUE)
    #--------------------------------------------------------------------------
    #   Ordinary Kriging  auf dem Trainingsdatensatz
    #--------------------------------------------------------------------------
    ZV.okr <- krige(ZV.model ~ 1, ~ X + Y, dat1.model, dat1.valid, model = v.fit)
    ZV.pred <- ZV.okr$var1.pred
    ZVpred[i] <- ZV.pred
    ZVvalid[i] <- ZV.valid
}
LOO <- data.frame(ZVvalid,ZVpred,ZVpred-ZVvalid)
LOO
summary(ZVpred-ZVvalid)
hist(ZVpred-ZVvalid)
plot(ZVpred,ZVvalid)
cor(ZVpred,ZVvalid)