rm(list=ls())
#--------------------------------------------------------------------------
#   Laden der packages
#--------------------------------------------------------------------------
library(lattice)
library(sp)
library(gstat)
# eine eigene Pausenfunktion:
pause <- function ()
{
    cat("Pause. Press <Enter> to continue...")
    readline()
    invisible()
}
#--------------------------------------------------------------------------
#   Voreinstellungen
#--------------------------------------------------------------------------
par(mfrow=c(1,1))
#--------------------------------------------------------------------------
#   Einlesen der Daten
#--------------------------------------------------------------------------
filename <- file.choose()
dat <- read.table(filename,header=TRUE)
names(dat) <- c("X","Y","P","EC","pH","NitCo","NitFlx")
cc <- complete.cases(dat)
dat1 <- dat[cc,]
ZV <- dat1$pH
#--------------------------------------------------------------------------
#   Erstellen eines Grids
#--------------------------------------------------------------------------
ndataX <- 100
ndataY <- 250
x <- seq(min(dat1$X),max(dat1$X),(max(dat1$X)-min(dat1$X))/(ndataX-1))
y <- seq(min(dat1$Y),max(dat1$Y),(max(dat1$Y)-min(dat1$Y))/(ndataY-1))
rpv <- rep(ndataY,ndataX)
u<-rep(1:ndataX,rpv);v<-rep(1:ndataY,ndataX)
w <- data.frame(cbind(x[u],y[v]))
dgr <- data.frame(X = w$X1, Y=w$X2)
plot(w$X1,w$X2,cex=0.2,pch=16,asp=1)
#coordinates(dat1) <- c("X", "Y")
#--------------------------------------------------------------------------
#  Emp. Variogramm
#--------------------------------------------------------------------------
cut.val = 2000
wdth.val = cut.val/10
vg1 <- variogram(ZV~1, loc = ~X+Y, dat1, cutoff = cut.val, width = wdth.val)
a <- plot(vg1, plot.numbers = TRUE, pch = 15, cex = 1.0, col="blue"
, xlim = range(0, 1.1*max(vg1$dist)), main = "Empirisches Variogramm")
print(a)
pause()
#--------------------------------------------------------------------------
# Anpassung eines sphrischen Variogrammmodells mit nugget
#--------------------------------------------------------------------------
mod1 <- vgm(0, "Gau", 500,1)
v.fit <- fit.variogram(vg1, model=mod1, fit.method=7, fit.sills=TRUE, fit.ranges=TRUE)
plot(vg1, model=v.fit, lwd=4,pch=15,cex=1.8, col="black", xlim = range(0, 1.1*max(vg1$dist)),
     main = "Bruchsal T1 pH\nGauss'sches Modell")
print(v.fit)
attr(v.fit,"SSErr")
pause()
#
#Einfhren von Anisotropie
#v.anis <- vgm(v.fit[2,2],"Gau",v.fit[2,3],v.fit[1,1], anis=c(45,0.5))
anis.sill <- as.numeric(v.fit[2,2])
anis.range <- as.numeric(v.fit[2,3])
anis.nugg <- as.numeric(v.fit[1,2])
v.anis <- vgm(anis.sill,"Gau",anis.range,anis.nugg, anis=c(45,0.5))
#--------------------------------------------------------------------------
#   Ordinary Kriging
#--------------------------------------------------------------------------
ZV.okr <- krige(ZV ~ 1, ~ X + Y, dat1, dgr, model = v.anis)
#
#cl <- colors()[seq(280,360,1)]
#cl <- topo.colors(100)
cl <- rainbow(100,start=.7,end=.25)
cts <- 40
# Schtzwerte: Contour
v <- ZV.okr$var1.pred
datmat <- matrix(v,byrow=T,nrow=ndataX)
filled.contour(x,y,datmat,asp=1,color = topo.colors,nlevels=50,
    , main="Ordinary kriging\n Schtzwerte"
    ,plot.axes={axis(1);axis(2)
    ; contour(x,y,datmat,nlevels=20,add=T,lwd=1,col="brown", axes=F)
    ; points(dat1$X,dat1$Y,pch=16,col="white",cex=1,lwd=1)})
#--------------------------------------------------------------------------
#   conditional simulation map
#--------------------------------------------------------------------------
xs <- krige(ZV ~ 1, ~ X + Y, dat1, dgr, model = v.anis, nmax=10, nsim=6)
for (i in 3:8) {
  v <- xs[,i]
  datmat <- matrix(v,byrow=T,nrow=ndataX)
  filled.contour(x,y,datmat,asp=1,color = topo.colors,nlevels=50,
, main=paste("conditional simulation ",as.character(i-2)))
}#
#--------------------------------------------------------------------------
#   unconditional simulation map
#--------------------------------------------------------------------------
xs <- krige(ZV ~ 1, ~ X + Y, data = NULL, newdata = dgr, nmax=10, nsim=6,
      dummy=TRUE, model = v.anis, beta = c(mean(ZV.okr$var1.pred)))
for (i in 3:8) {
  v <- xs[,i]
  datmat <- matrix(v,byrow=T,nrow=ndataX)
  filled.contour(x,y,datmat,asp=1,color = topo.colors,nlevels=50,
, main=paste("unconditional simulation ",as.character(i-2)))
}
