rm(list=ls())
#-------------------------------------------------------
#  Wasserspeicherung
#-------------------------------------------------------
#
# --- Messdaten ---
#
psi.lab   <- c(0.010,    5,   10,   32,  100,  320, 15000)
theta.lab <- c(0.55, 0.53, 0.50, 0.46, 0.38, 0.30,  0.25)
plot(log10(psi.lab),theta.lab,type="o",ylim=1.1*c(0,max(theta.lab))
    ,main="pF - Kurve",lwd=2)
#
# --- Auswertung ---
#
por <- theta.lab[1]
wv.18 <- theta.lab[4]
wv.42 <- theta.lab[7]
fk  <- wv.18
lk  <- por - fk
wwk <- wv.42
nfk <- fk - wwk
#
# --- Ausgabe ---
#
cat(" \n--- Messdaten ---\n")

cat(" \n--- Wasserspeicherung ---\n")
cat("\n Porositt: ",round(por,3),"\n\n")
cat("\n Luftkapazitt: ",round(lk,3),"\n\n")
cat("\n Feldkapazitt: ",round(fk,3),"\n\n")
cat("\n Welkepunkt-Wasserkapazitt: ",round(wwk,3),"\n\n")
cat("\n Nutzbare Feldkapazitt: ",round(nfk,3),"\n\n")
# --- Skriptende ---