#-------------------------------------------------------
#  Visuelle Anpassung des van Genuchten/Mualem-Modells
#-------------------------------------------------------
# Aufgabe: Versuchen Sie durch Parametervariation eine 
#          gute Anpassung an die Messdaten zu erhalten
#
# --- Parametrisierung der Wasserspannungskurve ---
#
theta_VG <- function(alpha,n,theta_s,theta_r,psi) {
    m <- 1-1/n
    theta_VG <- theta_r + (theta_s-theta_r)/(1+(alpha*psi)^n)^m
}
#
# --- Mualemmodell fr die relative hydraulische Leitfhigkeit ---
#
K_VGrel <- function(alpha,n,theta_s,theta_r,psi) {
    m <- 1-1/n
    K_VGrel <- (1-(alpha*psi)^(n-1)*(1+(alpha*psi)^n)^(-m))^2/
                 (1+(alpha*psi)^n)^(m/2)
}
#
# --- Messdaten ---
#
psi_lab   <- c(0.10,    5,   10,   32,  100,  320, 15000)
theta_lab <- c(0.55, 0.53, 0.50, 0.46, 0.38, 0.30,  0.25)
#
# --- Modellparameter ---
#
theta_s <- 0.55   # Sttigungswassergehalt
theta_r <- 0.25   # Residualwassergehalt
K_s <- 100        # Wasserleitfhigkeit z.B. cm/d
alpha <- 0.8      # emp. Formparameter
n <- 2.5          # emp. Formparameter
# 
# --- Darstellung der Wasserspannungskurve ---
#
pF <- seq(-1,6,0.2)
psi <- 10^pF
theta <- theta_VG(alpha,n,theta_s,theta_r,psi)
par(mfrow=c(3,1),mar=c(4,4,4,2))
plot(log10(psi),theta,type="o", main="Wasserspannungskurve")
# Einzeichnen der Messdaten:
points(log10(psi_lab),theta_lab,pch=15,col="blue")
# 
# --- Darstellung der Relativen Leitfhigkeit ---
#
#
K_rel <- K_VGrel(alpha,n,theta_s,theta_r,psi)
K <- K_s*K_rel
plot(log10(psi),K,type="o",ylim=c(0,max(K)), main="Wasserleitfhigkeitskurve")
plot(log10(psi),K_rel,type="o",ylim=c(0,max(K_rel)), main="Relative Leitfhigkeit")
# Skriptende