#-------------------------------------------------------
#  Visuelle Anpassung des van Genuchten/Mualem-Modells
#-------------------------------------------------------
# Aufgabe: Versuchen Sie durch Parametervariation eine 
#          gute Anpassung an die Messdaten zu erhalten
#
# --- Parametrisierung der Wasserspannungskurve ---
#
theta_VG <- function(alpha,n,theta_r,psi) {
    m <- 1-1/n
    theta_VG <- theta_r + (theta_s-theta_r)/(1+(alpha*psi)^n)^m
}
#
# --- Mualemmodell fr die relative hydraulische Leitfhigkeit ---
#
K_VGrel <- function(alpha,n,theta_s,theta_r,psi) {
    m <- 1-1/n
    K_VGrel <- (1-(alpha*psi)^(n-1)*(1+(alpha*psi)^n)^(-m))^2/
                 (1+(alpha*psi)^n)^(m/2)
}
#
# --- Messdaten ---
#
psi_lab   <- c(0.10,    5,   10,   32,  100,  320, 15000)
theta_lab <- c(0.55, 0.53, 0.50, 0.46, 0.38, 0.30,  0.25)
#
# --- Modellparameter ---
#
theta_s <- 0.55   # Sttigungswassergehalt
theta_r <- 0.25   # Residualwassergehalt
K_s <- 100        # Wasserleitfhigkeit z.B. cm/d
alpha <- 0.08      # emp. Formparameter
n <- 3.5          # emp. Formparameter
#
# --- Modellanpassung ---
#
y <- theta_lab; x <- psi_lab
model <- nls(y~theta_VG(alpha,n,theta_r,x),model=TRUE,
             start=list(alpha=alpha,n=n,theta_r=theta_r))
print(summary(model))
#
par(mfrow=c(3,1),mar=c(5,5,4,2))
pF <- seq(-1,4.2,0.2)
psi <- 10^pF
plot(log10(psi_lab),theta_lab,pch=15,col="blue",cex=1.5,
main="Fit: van Genuchten/\nMualem-Model")
lines(log10(psi),predict(model,list(x=psi)),lty=1,lwd=1,col="gray4")
#
par <- model$m$getAllPars()
alpha_o <- par[1]
n_o <- par[2]
theta_r_o <- par[3]
K_s <- 100 # cm/d
K_rel <- K_VGrel(alpha_o,n_o,theta_s,theta_r_o,psi)
K <- K_s*K_rel
plot(log10(psi),K,type="o",ylim=c(0,max(K)))
plot(log10(psi),K_rel,type="o",ylim=c(0,max(K_rel)))
# Skriptende