rm(list=ls())
library(DAAG)
par(mfrow=c(1,1))
# Einlesen und verwurschten des Datensatzes
data  <- read.table("OBS_NODE.txt",header=T)
ind   <- seq(4,31,3)
data  <- data[,-ind]
ind   <- seq(1,151,5)
time  <- data[ind,1]
data  <- data[ind,]
ind   <- seq(3,21,2)
theta <- as.matrix(data[,ind])
ind   <- seq(2,20,2)
psi <- as.matrix(data[,ind])
depth <- c(-1.7094, -5.2632, -10.9312, -17.004, -25.7310, -35.1777, -47.9982,
           -67.8363, -83.3558, -96.5812)
head(data)
#
# Contourgraphiken von Wassergehalten und Matrixpotentialen
#
x <- time
y <- depth
cls <- rainbow(70,start=0.001,end=1.)
filled.contour(abs(x),abs(y),theta,ylim = c(100,0),col = cls,nlevels=50,
, main="Wassergehalte",plot.axes={axis(1);axis(2)
; contour(abs(x),abs(y),theta,nlevels=20,add=T,lwd=1,col="brown", axes=F)
})
pause()
filled.contour(abs(x),abs(y),psi,ylim = c(100,0),col = cls,nlevels=50,
, main="Matrixpotentiale",plot.axes={axis(1);axis(2)
; contour(abs(x),abs(y),psi,nlevels=20,add=T,lwd=1,col="brown", axes=F)
})
